#include <windows.h>
#include <ScrnSave.h>
#include <tchar.h>
#include <time.h>

#pragma comment(lib, "ScrnSavw.lib")
#pragma comment(lib, "ComCtl32.lib")

const int WAIT_TIME = 100;
const int ROOP = 100;

LRESULT WINAPI ScreenSaverProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	static RECT rc;
	const int ID_TIMER = 100;
	switch(msg){
		case WM_CREATE:{
			srand((unsigned int)time(NULL));
			SetTimer(hWnd, ID_TIMER, WAIT_TIME, NULL);
			GetClientRect(hWnd, &rc);
			LONG exStyle = GetWindowLong(hWnd,GWL_EXSTYLE);
			SetWindowLong(hWnd, GWL_EXSTYLE, exStyle | WS_EX_LAYERED);
			SetLayeredWindowAttributes(hWnd, RGB(0,0,0), 0, LWA_COLORKEY);
			break;
		}
		case WM_TIMER:{
			if(wParam != ID_TIMER){
				break;
			}
			HDC hdc = GetDC(hWnd);

			HFONT hFont = CreateFont(60,0,0,0,FW_REGULAR, FALSE, FALSE, FALSE, SHIFTJIS_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, PROOF_QUALITY, FIXED_PITCH | FF_MODERN, _T("lr@SVbN"));
			SelectObject(hdc, hFont);
			TCHAR *str = _T("eXgXN[ZCo[");
			SIZE s;
			GetTextExtentPoint32(hdc,str, (int)_tcslen(str), &s);
			int x = (rand() % rc.right) - s.cx / 2;
			int y = (rand() % rc.bottom) - s.cy / 2;
			int r = rand() % 256;
			int g = rand() % 256;
			int b = rand() % 256;
			SetBkMode(hdc, TRANSPARENT);
			SetTextColor(hdc, RGB(r,g,b));
			TextOut(hdc, x, y, str, (int)_tcslen(str));

			static int n = 0;
			n++;
			if( n > ROOP){
				n = 0;
				PatBlt(hdc, 0, 0, rc.right, rc.bottom, BLACKNESS);
			}
			DeleteObject(hFont);
			ReleaseDC(hWnd, hdc);
			break;
		}
		case WM_DESTROY:
			KillTimer(hWnd, ID_TIMER);
			PostQuitMessage(0);
			break;
		default:
			break;
	}
	return DefScreenSaverProc(hWnd, msg, wParam, lParam);
}

BOOL WINAPI ScreenSaverConfigureDialog(HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam)
{
	return TRUE;
}

BOOL WINAPI RegisterDialogClasses(HANDLE hInst)
{
	return TRUE;
}
